// DeleteHolidayGroup.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "DeleteHolidayGroup.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDeleteHolidayGroup dialog


CDeleteHolidayGroup::CDeleteHolidayGroup(CWnd* pParent /*=NULL*/)
	: CDialog(CDeleteHolidayGroup::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDeleteHolidayGroup)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}
CDeleteHolidayGroup ::CDeleteHolidayGroup(IApplication *pApp):CDialog(CDeleteHolidayGroup::IDD, NULL)
{
	pApplication = pApp;
	pHolGrp.CreateInstance(__uuidof(HolidayGroup));
	
}


void CDeleteHolidayGroup::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDeleteHolidayGroup)
	DDX_Control(pDX, IDC_LIST_PANEL_HG, m_PanelList);
	DDX_Control(pDX, IDC_COMBO_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_COMBO_HOLGRPLIST, m_HolGrpList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDeleteHolidayGroup, CDialog)
	//{{AFX_MSG_MAP(CDeleteHolidayGroup)
	ON_CBN_SELCHANGE(IDC_COMBO_ACCTLIST, OnSelchangeComboAcctlist)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	ON_BN_CLICKED(IDC_BTN_ISOLATE, OnBtnIsolateHG)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDeleteHolidayGroup message handlers

BOOL CDeleteHolidayGroup::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX P;roperty Pages should return FALSE
}
void CDeleteHolidayGroup :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sAcctID;
				sAcctID.Format(L"%ld",pAccount->AccountID);
				m_AcctList.AddString(sAcctID);
				pAccount->Release();
			}
			pDisp->Release();
		}
		//m_AcctList.SetCurSel(0);
	UpdateData(FALSE);
}

void CDeleteHolidayGroup::OnSelchangeComboAcctlist() 
{
	m_HolGrpList.ResetContent();
	int index = m_AcctList.GetCurSel();
	CString sAcctName;
	m_AcctList.GetLBText(index,sAcctName);

	long lAccountID = _wtoi(sAcctName);
	_variant_t vHolGrps;
	vHolGrps.Clear();
	pApplication->GetHolidayGroupsByAcctID(lAccountID,&vHolGrps);
	if(vHolGrps.vt == VT_EMPTY)
	{
			AfxMessageBox(L"No holiday groups");
			return;
	}	
	long uBound =0 ;
	IHolidayGroup *pHolGrp =NULL;
	COleSafeArray sa(vHolGrps);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	//BSTR bstrPanel;
	for(long i =0 ;i <= uBound ; i++)
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IHolidayGroup,(void**)&pHolGrp);
		if (pHolGrp != NULL)
		{	
			CString sHolGrpID;
			sHolGrpID.Format(L"%ld",pHolGrp->HolGrpID);
			m_HolGrpList.AddString(sHolGrpID);	
			pHolGrp->Release();
		}
		pDisp->Release();
	}	
}

void CDeleteHolidayGroup::OnButtonDelete() 
{
	
	int index = m_HolGrpList.GetCurSel();
	CString sHolidayName;
	m_HolGrpList.GetLBText(index,sHolidayName);

	long lHolGrpID = _wtoi(sHolidayName);

	long lstatus;
	pApplication->DeleteHolidayGroup(lHolGrpID,&lstatus);
	if ( lstatus == 809)
	{
		AfxMessageBox(L"Holiday group does not exist");
		return;	
	}
	if ( lstatus == 606)
	{
		AfxMessageBox(L"Holiday group is associated with panels cannot be deleted");
		return;	
	}
	if ( lstatus == 1)
	{
		AfxMessageBox(L"Holiday group Deletion Failed");
		return;	
	}
	else
	{
		AfxMessageBox(L"Holiday group Deletion Succeded");
		CDialog::OnOK();
	}	
}

void CDeleteHolidayGroup::OnBtnIsolateHG() 
{
	m_PanelList.ResetContent();

	int index = m_AcctList.GetCurSel();
	CString sAcctID;
	m_AcctList.GetLBText(index,sAcctID);
	long lAcctID = _wtoi(sAcctID);

	int index_HG = m_HolGrpList.GetCurSel();
	CString sHolidayName;
	m_HolGrpList.GetLBText(index_HG,sHolidayName);

	long lHolGrpID = _wtoi(sHolidayName);

	_variant_t vPanels;
	vPanels.Clear();
	long lStatus;
	pApplication->IsolatePanelsForHGDelete(lAcctID, lHolGrpID, &vPanels, &lStatus);


	if ( lStatus == 605)
	{
		AfxMessageBox(L"Invalid Holiday Group");
		return;
	}
	else if ( lStatus == 105)
	{
		AfxMessageBox(L"Invalid Account");
		return;
	}
	else if(vPanels.vt == VT_EMPTY || vPanels.vt == VT_NULL || vPanels.parray->rgsabound->cElements == 0)
	{
		AfxMessageBox(L"No Panels Associated");
		return;
	}
	else
	{
		long uBound =0 ;
			
		COleSafeArray sa(vPanels);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		long lPanelID = 0;
		BSTR bstrPanelName = SysAllocString(L"");
		for(long i =0 ;i <= uBound ; i++)
		{
			sa.GetElement(&i,(void*)&bstrPanelName);
			CString sPanel = CString(bstrPanelName);
			m_PanelList.AddString(sPanel);
		}
	}
}
